/*
 * UCS.c
 *
 *  Created on: Jan 21, 2020
 *      Author: a0222913
 */


#include <TLC6983DMA.h>
#include <msp430.h>

void ucsInitial()
{
    //ucs setting
    P5SEL |= (BIT4 | BIT5);
    UCSCTL6 |= (XT2OFF | XT1DRIVE_3 | XTS);
    UCSCTL6 &= ~(XT1OFF);
    do{
        UCSCTL7 &= ~XT1LFOFFG;
    }while(UCSCTL7&XT1LFOFFG);
    UCSCTL6 |= XT1DRIVE_0;
    UCSCTL3 = (SELREF__XT1CLK | FLLREFDIV__8);
    __bis_SR_register(SCG0);
    UCSCTL1 = DCORSEL_5;//DCORSEL_5
    UCSCTL2 =0x3004; //D = 8, N=4, 0x3004
    __bis_SR_register(SCG0);
    UCSCTL4 = (SELA__DCOCLKDIV | SELS__DCOCLK | SELM__DCOCLK);//ACLK = 20/8 = 12.5MHz
    //SELA__DCOCLKDIV | SELS__DCOCLK | SELM__DCOCLK


   // Loop until XT1,XT2 & DCO stabilizes - in this case loop until XT1 settles
   do
   {
       UCSCTL7 &= ~(XT2OFFG + XT1LFOFFG + DCOFFG);
                                            // Clear XT2,XT1,DCO fault flags
   }while (UCSCTL7&DCOFFG);                   // Test oscillator fault flag


   //Output ACLK
   P1DIR |= BIT0;
   P1SEL |= BIT0;
   //Output SMCLK
   P2DIR |= BIT2;
   P2SEL |= BIT2;
}

void timerInitial()
{
    TA2CTL |= TASSEL_2 + MC_0; //select SMCLK clock source, select /1 =20MHz, divider, select stop mode
#ifdef _LOW_FREQUENCY
    TA2CCTL1 |= OUTMOD_2; //TA2.1 select toggle/reset mode//OUTMOD_2
    TA2CCR0 = 7;//TA output = 20MHz/8 = 2.5MHz
    TA2CCR1 = 4;
#else
    TA2CCTL1 |= OUTMOD_2; //TA2.1 select toggle/reset mode//OUTMOD_2
    TA2CCR0 = 3;//3
    TA2CCR1 = 2;
#endif

    P2DIR |= BIT4; //P2.4 set as output
    P2SEL |= BIT4;//P2.4 -> TA2.1
    TA2CTL |= MC_1; //select up mode to start timer
}

